-- ANMERKUNG: siehe "Y TWawi.Views.Auftrag.sql"

CREATE OR REPLACE FUNCTION TSystem.views__wawi_Ausgangsrechnung__drop() RETURNS VOID AS $$
  BEGIN

    DROP FUNCTION IF EXISTS TWawi.extend_layout__beleg__dms(TWawi.rechnungv_belegext);
    DROP FUNCTION IF EXISTS TWawi.extend_layout__beleg__notes(TWawi.rechnungv_belegext);    

    DROP FUNCTION IF EXISTS TWawi.view__pos__normalize(TWawi.rechnungv_pos);
    DROP FUNCTION IF EXISTS TWawi.view__beleg__normalize(TWawi.rechnungv_belegext);

    -- Bestehende-Views droppen
        DROP VIEW IF EXISTS TWawi.rechnung_belegext;

        DROP VIEW IF EXISTS TWawi.rechnung_belegext;
        DROP VIEW IF EXISTS TWawi.rechnung_posext;

        DROP VIEW IF EXISTS TWawi.rechnungv_posall;
        DROP VIEW IF EXISTS TWawi.rechnungv_posext; -- neu analog TSystem_Wawi
        DROP VIEW IF EXISTS TWawi.rechnungv_pos;

        DROP VIEW IF EXISTS TWawi.rechnungv_belegext;
    --
    
    RETURN;

  END $$ LANGUAGE plpgsql; 

--
CREATE OR REPLACE FUNCTION TSystem.views__Wawi_Ausgangsrechnung__recreate() RETURNS VOID AS $f0$
  BEGIN

    PERFORM TSystem.views__wawi_Ausgangsrechnung__drop();

    -- Basis-View => Updatable, da kann man reinschreiben. Nur Felder aus Basistabelle, keine NULLs, keine Funktionen, keine Felder anderer Tabellen.
    --
    -- Da die Grundtabelle belzeil_grund nicht wirklich für ein UPDATE geeignet ist (wird nicht in die relevanten abgeleiteten Tabellen geschrieben)
    -- und die Umsetzung der 2 abgeleiteten Tabellen belzeil_auftg_lif und belzeil_frei unklar ist, erstmal keine Updatable-Views.
    --
    CREATE OR REPLACE VIEW TWawi.rechnungv_belegext AS
      SELECT
        belkopf.dbrid                                                AS dbrid, -- wegen datarowstate!
        belkopf.dbrid                                                AS d_dbrid,
        be_bnr                                                       AS d_id,

        be_bnr                                                       AS d_dokunr,

        be_abprozent                                                 AS d_aproz, --An/Abschlagsrechnung-Prozent

        be_prof                                                      AS d_typ,
        be_prof                                                      AS d_code,
        be_def                                                       AS d_definitiv,
        belkopf.insert_date                                          AS d_insert_date,
        belkopf.insert_by                                            AS d_insert_by,
        be_bdat                                                      AS d_datum_erfasst,

        extract(year FROM be_bdat)::integer                          AS d_datum_erfasst__year,
        extract(week FROM be_bdat)::integer                          AS d_datum_erfasst__week,
        extract(quarter FROM be_bdat)::integer                       AS d_datum_erfasst__quarter,
        extract(month FROM be_bdat)::integer                         AS d_datum_erfasst__month,

        be_txba                                                      AS d_txba,

        coalesce(be_titel, lang_belart(be_txba))                     AS d_titel,
        coalesce(be_bem1_rtf, be_bem1)                               AS d_kopftext,
        coalesce(be_bem2_rtf, be_bem2)                               AS d_fusstext,
        be_bem1                                                      AS d_kopftext_txt,
        be_bem2                                                      AS d_fusstext_txt,

        adk_ad_krz::varchar(30)                                      AS d_adk_ad_krz, --richtiges Adresskürzel (Liefer/Rechnungs-Unteradresskürzel)
        adressename( adk_ad_krz )                                    AS d_adk_ad_krz__name,
        be_rkrz                                                      AS d_ada_krzl,

        be_apkrzl                                                    AS d_apext,
        be_ap                                                        AS d_apextname,

        p_refnummer__agg                                             AS d_refnummer,

        be_apint                                                     AS d_apint,
        nameAufloesen(be_apint)                                      AS d_apintname,

        ad_ustidnr                                                   AS d_ad_ustidnr,

        be_zak                                                       AS d_zahlung_tage,
        be_skv                                                       AS d_zahlung_skv,
        be_sks                                                       AS d_zahlung_sks,
        be_kond                                                      AS d_zahlung_bemerkung,
        be_bdat + be_zak                                             AS d_datum_soll,
        be_buchdat                                                   AS d_datum_fibu_buchung, -- Datum des Exports in die Buchhaltungsschnittstelle

        be_zahl_erledigt                                             AS d_zahlung_done,

        wert_gs_faktor,
        be_gesamt_net               * wert_gs_faktor                 AS d_wert_tot_netto,
        be_gesamt_steu              * wert_gs_faktor                 AS d_wert_tot_brutto,

        be_gesamt_net_basis_w       * wert_gs_faktor                 AS d_wert_tot_netto_gwaer,
        be_gesamt_steu_basis_w      * wert_gs_faktor                 AS d_wert_tot_brutto_gwaer,

        a1_knr                                                       AS d_adk_knr,
        a1_toltext                                                   AS d_toltext,
        be_pruefer                                                   AS d_pruefer,
        be_freigabe                                                  AS d_freigabe,

        COALESCE(be_waco, TSystem.Settings__BASIS_W__Get() )::VARCHAR(10)        AS d_waco
      FROM belkopf
        JOIN LATERAL (SELECT CASE WHEN be_prof /*d_typ*/ = 'G' THEN -1 ELSE 1  END AS wert_gs_faktor) AS negativ ON true
        LEFT JOIN adressen_view ON ad_krz = be_rkrz --wegen Debitorendaten
        LEFT JOIN adk1          ON a1_krz = adk_ad_krz --debitorendaten zur Adresse
        LEFT JOIN adkap         ON adk_ad_krz = ap_ad_krz AND ap_krzl = be_apkrzl AND ap_krzl IS NOT NULL
        LEFT JOIN LATERAL (SELECT string_agg(DISTINCT bz_bda, ';' ORDER BY bz_bda)::varchar(300) AS p_refnummer__agg FROM belzeil_grund WHERE bz_be_bnr = be_bnr) AS pos_aggs ON true
      ORDER BY
        be_bdat DESC, be_bnr DESC
    ;

    CREATE OR REPLACE VIEW TWawi.rechnungv_pos AS
      SELECT
      -- Identifikatoren      

        dbrid,--
        bz_id                AS p_id                      ,-- ID der Pos.
        bz_be_bnr            AS p_d_id                    ,-- Referenz auf das zug. Dokument
    
        bz_be_bnr            AS p_dokunr                  ,-- Referenz auf das zug. Dokument    
        bz_be_bnr            AS p_nummer                  ,-- Belegnummer
        bz_pos               AS p_pos                     ,-- Positionsnummer
        bz_hwpos             AS p_parent                  ,-- Übergeordnete Position (Strukt. Belege)
      -- Artikeldaten
        bz_aknr              AS p_aknr                    ,-- Artikelnummer
        bz_akbz              AS p_akbz                    ,-- Überschriebene Artikelbezeichnung (wenn <> art.ak_bez)
        bz_fakt              AS p_menge                   ,-- Menge in Positions-ME
        bz_mce               AS p_me                      ,-- artmgc.m_id der Positions-ME
        bz_fakt_uf1          AS p_menge_gme               ,-- Menge in GME
        bz_fakt              AS p_mengeo                  ,-- Noch zu bestellende Menge
        bz_fakt_uf1          AS p_mengeo_gme              ,-- Noch zu bestellende Menge in GME
        bz_ks                AS p_ks                      ,-- Zugeordnete Kostenstelle
      -- Preisdaten
        bz_preis             AS p_preis                   ,-- Preis pro ME (enthält Preiseinheit)
        bz_vkptotalpos       AS p_preis_sumsubpos         ,
        bz_preiseinheit      AS p_preiseinheit            ,-- Menge auf die sich p_preis bezieht
        bz_vkp               AS p_preis_me                ,-- Preis pro ME
        bz_ep_netto          AS p_preis_netto             ,-- Preis pro ME inkl. Rabatt
        bz_vkp_basis_w       AS p_preis_gwaer             ,-- Preis pro ME in Grundwährung
        bz_vkp_uf1           AS p_preis_gme               ,-- Preis pro GME
        bz_vkp_uf1_basis_w   AS p_preis_gme_gwaer         ,-- Preis pro GME in Grundwährung
        bz_steucode          AS p_steu_code               ,-- Steuercode
        bz_steuproz          AS p_steu_proz               ,-- Steuerprozentsatz
        bz_gesrab            AS p_rabatt_gesamt           ,-- Rabattsatz (0...100)
        bz_arab              AS p_rabatt                  ,
        bz_canrabatt         AS p_rabatt_able             ,-- Kennzeichen Rabattfähig

        insert_date          AS p_insert_date             ,-- Eingangsdatum
        bz_buchdone          AS p_done                    ,-- Kennzeichen Pos. Erledigt

      -- Referenzen / Struktur
        bz_bda               AS p_refnummer               ,-- Referenz auf ext.Nummer   (Z.Bsp. Bestell-Nr.  Kunde)

        bz_lfs               AS p_refnummer_lfs,

        bz_auftg             AS p_refnummer_auftg,        --p_refnummer_wawi?
        bz_auftgpos          AS p_refnummer_auftg_pos,    --p_refnummer_wawi_pos?

        bz_an_nr             AS p_an_nr                   ,-- Projektnummer

      -- Erweiterte Positionsdaten
        bz_zeko              AS p_konto                   ,-- Kontierung
        bz_zubez             AS p_txt_ext                 ,-- Positionstext extern
        bz_zubez_rtf         AS p_txt_ext_rtf
      FROM belzeil_grund AS pos;

    -- Erweiterter Anzeige-View => Nur lesbar.
    CREATE OR REPLACE VIEW TWawi.rechnungv_posext AS
      SELECT
          pos.dbrid                                       AS dbrid,
          p_id                                            AS p_id,
          p_d_id                                          AS p_d_id,
      
          d_typ                                           AS p_typ,          -- Klassifikation als ID
          d_code                                          AS p_code,         -- übersetzter Code (aus Lateral Join o.Ä.)
      
          'rechnungv_pos'::varchar(64)                    AS p_table,

          d_definitiv                                     AS p_definitiv,
      
          d_adk_ad_krz                                    AS p_adk_ad_krz,
      
          -- Artikeldaten (zusätzliche Angaben)
          ak_ac                                           AS p_ak_ac,
          COALESCE(ag_aknr_idx, ak_idx)                   AS p_aknr_idx,
          COALESCE(bz_akbz, ak_bez)                       AS p_ak_bez,
          ag_aknr_referenz                                AS p_aknr_referenz,
          ak_los                                          AS p_los,
          ak_norm                                         AS p_norm,
      
          -- Mengeneinheitsdaten
          MEData.p_gme                                    AS p_gme,
          MEData.p_mec                                    AS p_mec,
          MEData.p_gmec                                   AS p_gmec,
          MEData.p_meuf                                   AS p_meuf,
          MEData.p_meiso                                  AS p_meiso,
          MEData.p_gmeiso                                 AS p_gmeiso,
      
          -- Steuerbezeichnung
          steu_txt                                        AS p_steu_bez,
          steu_txt                                        AS p_sbez,
      
          -- Positionswerte
          bz_tot              * wert_gs_faktor           AS p_wert_tot_netto,
          bz_tot_steu         * wert_gs_faktor           AS p_wert_tot_brutto,
          bz_tot_basis_w      * wert_gs_faktor           AS p_wert_tot_netto_gwaer,
          bz_tot_steu_basis_w * wert_gs_faktor           AS p_wert_tot_brutto_gwaer,
      
          d_waco                                          AS p_waco,
          be_umr                                          AS p_kurs,
      
          -- Umsatz-/Statistikkennzeichen
          false                                           AS p_nstatistik,
          true                                            AS p_IsUmsatz,
      
          -- Ansprechpartner intern - erweiterte Info
          nameAufloesen(be_apint)                         AS p_apintname,
      
          -- Zusätzliche Termine
          pos.insert_date                                 AS p_insert_date,
          d_datum_erfasst                                 AS p_datum_erfasst,       -- Erfassdatum
          be_bdat + COALESCE(be_zak, 0)                  AS p_datum_soll,
          be_bdat + COALESCE(be_zak, 0)                  AS p_datum_ist,
          be_bdat + COALESCE(be_zak, 0)                  AS p_datum_istsoll,
          be_buchdat                                      AS p_datum_fibu_buchung,
          NULL::DATE                                      AS p_datum_storniert,
      
          -- Weitere Statusangaben
          false                                           AS p_storniert,
          NULL::BOOLEAN                                   AS p_IsBedarf,
          ak_fertigung                                    AS p_IsFertigung,
      
          NULL::VARCHAR                                   AS p_status,
          NULL::VARCHAR                                   AS p_status1,
          NULL::VARCHAR                                   AS p_status2,
      
          -- Zusätzliche Referenzen
          NULL::INT                                       AS p_a2_id,
          'auftg'::VARCHAR                                AS p_vorgaenger_table,
          ag_id                                           AS p_vorgaenger_id,
          NULL::INTEGER                                   AS p_refpos,
      
          -- Erweiterte Positionstexte
          NULL::TEXT                                      AS p_txt_int,
          NULL::TEXT                                      AS p_txt_int_rtf
      
      FROM TWawi.rechnungv_pos

        JOIN twawi.rechnungv_belegext ON d_id = p_d_id

        JOIN belzeil_grund AS pos   ON p_id = bz_id
        JOIN belkopf                ON be_bnr  = bz_be_bnr

        -- LEFT aufgrund mgl. freier Eingabe vom Artikel
        LEFT JOIN art               ON ak_nr   = bz_aknr
        JOIN adressen_view          ON ad_krz  = be_rkrz
        LEFT JOIN auftg             ON ag_astat = 'E' AND ag_nr = bz_auftg AND ag_pos = bz_auftgpos
        LEFT JOIN steutxt           ON steu_z  = bz_steucode
        -- Informationen zur Mengenumrechnung mit aufnehmen
        -- hier inkl. Sonderfall der freien Eingabe von ME und Artikel bei freier Rechnungsposition
        LEFT JOIN LATERAL (
            SELECT
              m2.m_id                               AS p_gme,   -- GME artikelspez. ID
              COALESCE(m1.m_mgcode, mfrei.me_cod)   AS p_mec,   -- ME-Code für auftragsbezogene bzw. freie Rechnungspos.
              m2.m_mgcode                           AS p_gmec,  -- GME-Code
              COALESCE(m1.m_uf, 1)                  AS p_meuf,  -- ME-UF mit Fallback auf 1 für freie Rechnungspos.

              -- ME-ISO-Bez.
              COALESCE(
                  -- auftragsbezogene Rechnungspos.
                  lang_artmgc_id_iso(m1.m_id),
                  -- Fallback auf freie Rechnungspos. (wenn ME-String in Stammdaten vorhanden)
                  lang_mgcode_iso(mfrei.me_cod),
                  -- Fallback auf komplett freie Eingabe bei freie Rechnungspos.
                  bz_mcbez
              )                                     AS p_meiso,

              lang_artmgc_id_iso(m2.m_id)           AS p_gmeiso -- GME-ISO-Bez.

            -- Ausgangspunkt 1 Zeile, Rest ggf. alles NULL
            FROM (SELECT true) AS one_row

              -- LEFT aufgrund mgl. freier Eingabe von ME
              LEFT JOIN artmgc m1  ON (m1.m_ak_nr  = ak_nr) AND (m1.m_id = pos.bz_mce)

              -- LEFT aufgrund mgl. freier Eingabe vom Artikel
              LEFT JOIN artmgc m2  ON (m2.m_ak_nr  = ak_nr) AND (m2.m_mgcode = ak_standard_mgc)

              -- Für freie Rechnungspos. wird nur ME-String eingetragen, #13462
              -- Daher wird versucht, den ME-Code anhand freier, sprachbezogener Eingabe (DE, EN usw.) zu ermitteln.
              LEFT JOIN LATERAL (
                  SELECT me_cod
                    FROM mgcodelang
                    JOIN mgcode ON me_cod = mel_me_cod

                  -- freie sprachbezogene Eingabe der ME bei freier Rechnungspos. Ggf. per F2 aus Stammdaten.
                   WHERE coalesce(mel_txt, me_bez, me_iso) = pos.bz_mcbez
                   ORDER BY me_cod
                   LIMIT 1 -- sicherheitshalber, falls Widersprüche mit String
              ) AS mfrei
                -- Nur wenn kein MCE aber freie Eingabe vorhanden ist.
                ON pos.bz_mce IS NULL AND pos.bz_mcbez IS NOT NULL

        ) AS MEData
          -- Infos zur Mengenumrechnung nur, wenn Artikel oder freie ME-Eingabe vorhanden ist.
          ON (ak_nr IS NOT NULL OR pos.bz_mcbez IS NOT NULL)
    ;

    PERFORM TSystem.view__combined__create('twawi', 'rechnungv_pos', 'rechnungv_posext', 'rechnungv_posall');

    CREATE OR REPLACE VIEW TWawi.rechnung_belegext AS SELECT * FROM TWawi.rechnungv_belegext; -- TODO => Prüfen alte Viewnamen gleich ersetzen durch rechnunge_ (analog TSystem_WawI)
    CREATE OR REPLACE VIEW TWawi.rechnung_posext   AS SELECT * FROM TWawi.rechnungv_posext;


    --
    EXECUTE $f1$


          CREATE OR REPLACE FUNCTION TWawi.view__pos__normalize(IN _p TWawi.rechnungv_pos)
            RETURNS SETOF TWawi.view__pos__type 
            AS $$
              WITH data AS (SELECT (_p).*)
              SELECT
                dbrid             ,
                p_id              ,
                p_d_id            ,
                p_pos             ,
                p_preis_sumsubpos 
              FROM data
            $$ LANGUAGE sql STABLE PARALLEL SAFE;
                    
          CREATE OR REPLACE FUNCTION TWawi.view__beleg__normalize(IN _p TWawi.rechnungv_belegext)
            RETURNS SETOF TWawi.view__beleg__type 
            AS $$
              WITH data AS (SELECT (_p).*)
                SELECT
                    dbrid,
                    d_id,
                    d_code,
                    d_wert_tot_netto,
                    d_wert_tot_brutto,
                    d_wert_tot_netto_gwaer,
                    d_wert_tot_brutto_gwaer,
                    d_datum_erfasst,
                    d_zahlung_tage,
                    d_zahlung_done               
                FROM data
            $$ LANGUAGE sql STABLE PARALLEL SAFE;


          CREATE OR REPLACE FUNCTION TWawi.extend_layout__beleg__dms(IN _b TWawi.rechnungv_belegext)
            RETURNS TABLE (
              DMS_get_dok_exists            boolean,
              preview_dokid                 integer,
              repository_tablename          varchar(64),
              repository_dbrid              varchar(64)
              )
              AS $$
                SELECT   -- DMS Dokumentvorschau
                    TDMS.Dokument__exists__by__dbrid( _b.d_dbrid ),
                    TDMS.Dokument__pd_id__by__pd_dbrid__pd_doktype(_b.d_dbrid, 'rechnung', 'belkopf')  AS preview_dokid,  -- Dokumentvorschau
                    'belkopf'::varchar(64)          AS repository_tablename,
                    _b.d_dbrid                      AS repository_dbrid ---belkopf.dbrid,                                                                                             
              $$ LANGUAGE sql STABLE PARALLEL SAFE;            

          CREATE OR REPLACE FUNCTION TWawi.extend_layout__beleg__notes(IN _b TWawi.rechnungv_belegext)
            RETURNS TABLE (
              menu_dbrid                    varchar(64),
              menu_tablename                varchar(64),
              menu_category                 varchar(64),
              menu_dbrid_2                  varchar(64),
              menu_tablename_2              varchar(64),
              menu_category_2               varchar(64),
              get_record_has_note           boolean
              )
              AS $$
                SELECT   -- DMS Dokumentvorschau
                       _b.dbrid                     AS menu_dbrid, 
                       'belkopf'                    AS menu_tablename, 
                       null                         AS menu_category,  -- Notizen Arbeitsgang

                       null                         AS menu_dbrid_2, 
                       null                         AS menu_tablename_2, 
                       null                         AS menu_category_2,  -- Notizen ABK

                       get_record_has_note(_b.dbrid) /*OR get_record_has_note(abk.dbrid, 'Auswärts')*/ AS get_record_has_note                                                                                           
            $$ LANGUAGE sql STABLE PARALLEL SAFE; 

    $f1$; -- EXECUTE end


  END $f0$ LANGUAGE plpgsql;
--


--- SELECT TSystem.views__Wawi_Ausgangsrechnung__recreate();